﻿var createSurveyTemplate = {
    context: $(".v-create-template"),
    allowSubmit: true,
    showValidationCopyFromSurvey: false,
    allTemplateList: [],
    bindDefaultValues: function () {
        a4.callServerMethod(a4.getAction("GetPublicSurveysForAutoComplete", "Home", "Survey"), {},
            function (response) {
                createSurveyTemplate.allTemplateList = response.map(function (item) {
                    return item.Label.toLowerCase();
                });
            });
    },
    initializeAutoCompletes: function () {

        $(".h-templates-category-autocomplete", createSurveyTemplate.context).a4autocomplete({
            ajaxAction: a4.getAction("GetTemplateCategoriesForAutoComplete", "Templates", "Library"),
            categoryProperty: "Folder",
            sortData: false,
            select: function (event, data) {
                $("#categoryId").val(data.item.Value);
            }
        });

        $(".h-copyfrom-autocomplete", createSurveyTemplate.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSurveysForAutoComplete", "Home", "Survey"),
            categoryProperty: "Folder",
            sortData: true,
            select: function (event, data) {
                $("#CopyFromId").val(data.item.Value);
                $("#CopySurveyNameValidation").addClass("d-none");
                $("#Source").removeAttr("checked").prop("checked", false);
                $("#Source[value=CopyFromSurvey]").attr("checked", "checked").prop("checked", true);
            }
        });

        $("#TimeToComplete", createSurveyTemplate.context).keypress(function (e) {
            var requiredPattern = /^[ A-Za-z0-9.<>-]*$/;
            var value = String.fromCharCode(e.keyCode);
            if (!value.match(requiredPattern)) {
                return false;
            }
        });

        createSurveyTemplate.context.on("click", "#submit", function () {
            var copyfromsurveyId = $("#CopyFromId").val();
            if (createSurveyTemplate.showValidationCopyFromSurvey && copyfromsurveyId != undefined && copyfromsurveyId != null && parseInt(copyfromsurveyId) == 0) {
                $("#CopySurveyNameValidation").removeClass("d-none");
                return false;
            }
            var templateName = $("#name-create-template").val();
            if (createSurveyTemplate.allTemplateList && createSurveyTemplate.allTemplateList.length > 0 && createSurveyTemplate.allTemplateList.includes(templateName.toLowerCase())) {
                $("#alreadyExistValidation").removeClass("d-none");
                return false;
            } else if (!$("#alreadyExistValidation").hasClass("d-none")){
                $("#alreadyExistValidation").addClass("d-none");
            }
            var timeToComplete = $("#TimeToComplete").val();
            var templateDescription = $("#Description").val();
            var templateCategoryId = $("#categoryId").val();
            if (templateName == undefined || templateName == null || templateName == "" || templateDescription == undefined || templateDescription == null || templateDescription == "" || timeToComplete == undefined || timeToComplete == null || timeToComplete == "" || templateCategoryId == undefined || templateCategoryId == null || templateCategoryId == "0") {
                $("#allFieldsValidation").removeClass("d-none");
                return false;
            } else if (!$("#allFieldsValidation").hasClass("d-none")) {
                $("#allFieldsValidation").addClass("d-none");
            }

            if (createSurveyTemplate.allowSubmit) {
                a4.parent().mySurveyTemplates.showBusyBox();
            }
            else
                return false;
        });

        createSurveyTemplate.context.on("change", ".h-source", function () {
            var source = $(this).val();
            if (source == sourceEnum.CopyFromSurvey) {
                createSurveyTemplate.showValidationCopyFromSurvey = true;
            } else {
                createSurveyTemplate.showValidationCopyFromSurvey = false;
                $("#CopySurveyNameValidation").addClass("d-none");
            }
        });
    },
    bindEvents: function () {
        this.context.on("change", ".h-fileUpload", function () {
            if ($(this).val().length !== 0) {
                var ext = $(this).val().split('.').pop().toLowerCase();
                var container = $(this).closest(".v-section");
                $(".v-importResult", container).hide();
                $(".h-create-template-clear", container).show();
                if ($.inArray(ext, ['jpg', 'jpeg']) == -1) {
                    $("#validateImageFile").removeClass("d-none");
                    createSurveyTemplate.allowSubmit = false;
                } else {
                    $("#validateImageFile").addClass("d-none");
                    createSurveyTemplate.allowSubmit = true;
                }
            }
        });

        this.context.on("click", ".h-create-template-clear", function () {
            var container = $(this).closest(".v-section");
            var fileUploadInput = $(".h-fileUpload", container);

            fileUploadInput.replaceWith($("<input />", { "type": "file", "id": fileUploadInput.attr("id"), "name": fileUploadInput.attr("name"), "class": fileUploadInput.attr("class"), "style": fileUploadInput.attr("style") }));

            $(this).hide();
            $(".v-sectionOptions", container).hide();
        });

    }
}

$(document).ready(function () {
    a4.parent().mySurveyTemplates.hideBusyBox();
    createSurveyTemplate.initializeAutoCompletes();
    createSurveyTemplate.bindEvents();
    createSurveyTemplate.bindDefaultValues();
});
